/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.UpdateException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.ObjectFactory;
import com.quantumdata.sct.dao.jaxb.TestResult;
import com.quantumdata.sct.dao.jaxb.TestResults;
import com.quantumdata.sct.dao.jaxb.TestResultsType;
import com.quantumdata.sct.dao.jaxb.TestStepResult;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.io.FileOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class TestResultsDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    public void readCallback() throws DAOException {
        try {
            TestResults testResults = (TestResults)this.daoObject;
            this.daoCollection.put(testResults.getUnitId(), new Integer(0));
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public IPersistable getValueObjectForKey(Object object) throws CreateException {
        try {
            return this.findByPrimaryKey((String)object);
        }
        catch (Exception exception) {
            throw new CreateException("Unable to create with key =" + object, null, exception);
        }
    }

    public IPersistable[] findByAll() throws Exception {
        IPersistable[] iPersistableArray = new IPersistable[]{this.createPersistable(this.daoObject)};
        return iPersistableArray;
    }

    public Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof TestResults) {
            TestResults testResults = (TestResults)object;
            object2 = testResults.getUnitId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    public final IPersistable createPersistable(Object object) throws Exception {
        TestResultsVO testResultsVO = new TestResultsVO();
        if (object instanceof TestResults) {
            this.copyFrom((TestResults)object, testResultsVO);
        }
        return testResultsVO;
    }

    protected void copyFrom(TestResults testResults, TestResultsVO testResultsVO) throws Exception {
        testResultsVO.setUnitId(testResults.getUnitId());
        testResultsVO.setLastUpdate(testResults.getLastUpdateTime());
        for (TestResultsType.TestResult testResult : testResults.getResults()) {
            TestResultVO testResultVO = new TestResultVO();
            testResultVO.setCapabilityId(testResult.getCapabilityId());
            testResultVO.setLastUpdate(testResult.getLastUpdateTime());
            testResultVO.setStatus(testResult.getStatus());
            for (TestStepResult testStepResult : testResult.getTestStepResultsCollection()) {
                TestStepResultVO testStepResultVO = new TestStepResultVO();
                testStepResultVO.setStatus(testStepResult.getStatus());
                testStepResultVO.setStepId(testStepResult.getStepId());
                for (TestStepResult.ParameterResult parameterResult : testStepResult.getResultParameters()) {
                    ParameterVO parameterVO = new ParameterVO();
                    parameterVO.setName(parameterResult.getId());
                    parameterVO.setValue(parameterResult.getValue());
                    testStepResultVO.getParameters().add(parameterVO);
                }
                testResultVO.add(testStepResultVO);
            }
            testResultsVO.add(testResultVO);
        }
    }

    protected static void copyTo(TestResults testResults, TestResultsVO testResultsVO, ObjectFactory objectFactory) throws Exception {
        testResults.setUnitId(testResultsVO.getUnitId());
        testResults.setLastUpdateTime(testResultsVO.getLastUpdate());
        for (TestResultVO testResultVO : testResultsVO.getStepresults()) {
            TestResultsType.TestResult testResult = objectFactory.createTestResultsTypeTestResult();
            testResult.setCapabilityId(testResultVO.getCapabilityId());
            testResult.setLastUpdateTime(testResultVO.getLastUpdate());
            testResult.setStatus(testResultVO.getStatus());
            for (TestStepResultVO testStepResultVO : testResultVO.getStepresults()) {
                TestResult.TestStepResult testStepResult = objectFactory.createTestResultTestStepResult();
                testStepResult.setStatus(testStepResultVO.getStatus());
                testStepResult.setStepId(testStepResultVO.getStepId());
                for (ParameterVO parameterVO : testStepResultVO.getParameters()) {
                    TestStepResult.ParameterResult parameterResult = objectFactory.createTestStepResultParameterResult();
                    parameterResult.setId(parameterVO.getName());
                    parameterResult.setValue(parameterVO.getValue());
                    testStepResult.getResultParameters().add(parameterResult);
                }
                testResult.getTestStepResultsCollection().add(testStepResult);
            }
            testResults.getResults().add(testResult);
        }
    }

    protected void copyTo(TestResults testResults, TestResultsVO testResultsVO) throws Exception {
        TestResultsDAO.copyTo(testResults, testResultsVO, this.factory);
    }

    public final void update(IPersistable iPersistable) throws UpdateException {
        if (iPersistable instanceof TestResultsVO) {
            try {
                TestResultsVO testResultsVO = (TestResultsVO)iPersistable;
                if (this.daoCollection.containsKey(testResultsVO.getId()) && testResultsVO.isDirty()) {
                    TestResults testResults = (TestResults)this.daoObject;
                    testResults.getResults().clear();
                    this.copyTo(testResults, testResultsVO);
                }
                this.flush();
                this.readCallback();
            }
            catch (Exception exception) {
                throw new UpdateException("Unable to reconcile");
            }
        } else {
            throw new UpdateException("Invalid Object", null);
        }
    }

    protected void updateObject(IPersistable iPersistable) throws Exception {
        if (this.daoCollection.containsKey(iPersistable.getId())) {
            TestResults testResults = (TestResults)this.daoObject;
            this.copyTo(testResults, (TestResultsVO)iPersistable);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) throws Exception {
        TestResultsVO testResultsVO = null;
        if (this.daoCollection.containsKey(string)) {
            TestResults testResults = (TestResults)this.daoObject;
            TestResultsVO testResultsVO2 = new TestResultsVO();
            this.copyFrom(testResults, testResultsVO2);
            testResultsVO = testResultsVO2;
        }
        return testResultsVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (this.daoCollection.containsKey(object)) {
                ((TestResults)this.daoObject).getResults().clear();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public void add(IPersistable iPersistable, int n) throws CreateException {
        throw new CreateException("Not supported for this method");
    }

    public void add(IPersistable iPersistable) throws CreateException {
        throw new CreateException("Not supported for this method");
    }

    public static void create(TestResultsVO testResultsVO, String string, String string2) throws CreateException {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            TestResults testResults = objectFactory.createTestResults();
            TestResultsDAO.copyTo(testResults, testResultsVO, objectFactory);
            JAXBContext jAXBContext = JAXBContext.newInstance(string2);
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.marshal((Object)testResults, new FileOutputStream(string));
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
    }
}

